rule Win32_Ransomware_BrainCrypt : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "BRAINCRYPT"
        description         = "Yara rule that detects BrainCrypt ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "BrainCrypt"
        tc_detection_factor = 5

    strings:

        $get_files_for_encryption_32 = {
            64 8B 0D ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 3B 61 ?? 0F 86 ?? ?? ?? ?? 83 EC ?? 80 7C 24 
            ?? ?? 74 ?? 8B 5C 24 ?? 89 1C 24 8B 5C 24 ?? 89 5C 24 ?? BB ?? ?? ?? ?? 89 5C 24 ?? 
            E8 ?? ?? ?? ?? 83 C4 ?? C3 83 3D ?? ?? ?? ?? ?? 0F 86 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 
            83 C3 ?? FC 8B 0B 89 0C 24 8B 4B ?? 89 4C 24 ?? 83 3D ?? ?? ?? ?? ?? 0F 86 ?? ?? ?? 
            ?? 8B 1D ?? ?? ?? ?? 83 C3 ?? 8D 7C 24 ?? FC 8B 0B 89 0F 8B 4B ?? 89 4F ?? E8 ?? ?? 
            ?? ?? 8B 5C 24 ?? 89 1D ?? ?? ?? ?? 8B 5C 24 ?? 80 3D ?? ?? ?? ?? ?? 75 ?? 89 1D ?? 
            ?? ?? ?? 8B 5C 24 ?? 89 1C 24 8B 5C 24 ?? 89 5C 24 ?? BB ?? ?? ?? ?? 89 5C 24 ?? E8 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 0C 24 8B 44 24 ?? C7 04 24 ?? ?? ?? ?? 89 4C 24 ?? 89 
            4C 24 ?? 89 44 24 ?? 89 44 24 ?? BB ?? ?? ?? ?? 89 5C 24 ?? C7 44 24 ?? ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8D 5C 24 ?? FC 8B 0B 89 0C 24 8B 4B ?? 89 4C 24 ?? E8 ?? ?? ?? ?? E9 
            ?? ?? ?? ?? BD ?? ?? ?? ?? 89 2C 24 89 5C 24 ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 0F 0B E8 ?? ?? ?? ?? 0F 0B E8 ?? ?? ?? ?? E9
        }

        $encrypt_file_32 = {
            64 8B 0D ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 3B 61 ?? 0F 86 ?? ?? ?? ?? 83 EC ?? 8B 5C 24 
            ?? 89 1C 24 8B 5C 24 ?? 89 5C 24 ?? E8 ?? ?? ?? ?? 8B 54 24 ?? 8B 4C 24 ?? 8B 44 24 
            ?? 89 54 24 ?? 89 14 24 89 4C 24 ?? 89 4C 24 ?? 89 44 24 ?? 89 44 24 ?? 8B 5C 24 ?? 
            89 5C 24 ?? 8B 5C 24 ?? 89 5C 24 ?? 8B 5C 24 ?? 89 5C 24 ?? E8 ?? ?? ?? ?? 8B 54 24 
            ?? 8B 4C 24 ?? 8B 44 24 ?? 8B 5C 24 ?? 89 1C 24 8B 5C 24 ?? 89 5C 24 ?? 89 54 24 ?? 
            89 54 24 ?? 89 4C 24 ?? 89 4C 24 ?? 89 44 24 ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 83 C4 ?? C3 E8 ?? ?? ?? ?? E9
        }

        $attach_to_server_32 = {
            64 8B 0D ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 3B 61 ?? 0F 86 ?? ?? ?? ?? 83 EC ?? 31 DB 89 
            5C 24 ?? 89 5C 24 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4C 24 ?? 89 CF 83 F9 ?? 
            0F 84 ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 89 4C 24 ?? 89 0C 24 83 3C 24 ?? 0F 84 ?? ?? 
            ?? ?? 8B 5C 24 ?? 89 5C 24 ?? 8B 5C 24 ?? 89 5C 24 ?? E8 ?? ?? ?? ?? 8B 5C 24 ?? 89 
            1C 24 83 3C 24 ?? 0F 84 ?? ?? ?? ?? BB ?? ?? ?? ?? 89 5C 24 ?? C7 44 24 ?? ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8B 5C 24 ?? 89 1C 24 83 3C 24 ?? 0F 84 ?? ?? ?? ?? BB ?? ?? ?? ?? 
            89 5C 24 ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5C 24 ?? 89 1C 24 83 3C 24 ?? 
            0F 84 ?? ?? ?? ?? 8B 5C 24 ?? 89 5C 24 ?? 8B 5C 24 ?? 89 5C 24 ?? E8 ?? ?? ?? ?? 8B 
            44 24 ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 31 DB 89 5C 24 ?? 89 5C 24 ?? 31 ED 39 E8 0F 85 
            ?? ?? ?? ?? B9 ?? ?? ?? ?? B8 ?? ?? ?? ?? 89 4C 24 ?? 89 0C 24 89 44 24 ?? 89 44 24 
            ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 89 44 24 ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 8B 48 ?? 8B 68 
            ?? 89 6C 24 ?? 89 6C 24 ?? 89 4C 24 ?? 83 F9 ?? 0F 84 ?? ?? ?? ?? 8D 59 ?? C7 04 24 
            ?? ?? ?? ?? 89 5C 24 ?? E8 ?? ?? ?? ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? C7 04 24 ?? ?? ?? 
            ?? 8B 44 24 ?? 83 F8 ?? 74 ?? 83 C0 ?? 8D 7C 24 ?? FC 8B 08 89 0F 8B 48 ?? 89 4F ?? 
            E8 ?? ?? ?? ?? 8D 5C 24 ?? FC 8B 0B 89 0C 24 8B 4B ?? 89 4C 24 ?? E8 ?? ?? ?? ?? 8B 
            54 24 ?? 8B 4C 24 ?? 8B 44 24 ?? C7 04 24 ?? ?? ?? ?? 89 54 24 ?? 89 54 24 ?? 89 4C 
            24 ?? 89 4C 24 ?? 89 44 24 ?? 89 44 24 ?? E8 ?? ?? ?? ?? 8B 5C 24 ?? 89 5C 24 ?? 8B 
            5C 24 ?? 89 5C 24 ?? 90 E8 ?? ?? ?? ?? 83 C4 ?? C3 
        }

        $get_files_for_encryption_64 = {
            65 48 8B 0C 25 ?? ?? ?? ?? 48 8B 89 ?? ?? ?? ?? 48 3B 61 ?? 0F 86 ?? ?? ?? ?? 48 83 
            EC ?? 48 89 6C 24 ?? 48 8D 6C 24 ?? 0F B6 44 24 ?? 84 C0 0F 85 ?? ?? ?? ?? 48 8B 05 
            ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 83 F9 ?? 0F 86 ?? ?? ?? ?? 48 8B 48 ?? 48 8B 40 
            ?? 48 89 0C 24 48 89 44 24 ?? 48 8B 05 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 83 F9 ?? 
            0F 86 ?? ?? ?? ?? 48 8B 48 ?? 48 8B 40 ?? 48 89 4C 24 ?? 48 89 44 24 ?? E8 ?? ?? ?? 
            ?? 48 8B 44 24 ?? 48 8B 4C 24 ?? 48 89 0D ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 84 C9 0F 85 
            ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 44 24 ?? 48 89 04 24 48 8B 44 24 ?? 48 89 44 
            24 ?? 48 8D 05 ?? ?? ?? ?? 48 89 44 24 ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 04 24 
            48 8B 4C 24 ?? 48 C7 04 24 ?? ?? ?? ?? 48 89 44 24 ?? 48 89 4C 24 ?? 48 8D 05 ?? ?? 
            ?? ?? 48 89 44 24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 
            4C 24 ?? 48 89 04 24 48 89 4C 24 ?? E8 ?? ?? ?? ?? 48 8B 6C 24 ?? 48 83 C4 ?? C3 48 
            8D 0D ?? ?? ?? ?? 48 89 0C 24 48 89 44 24 ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 0F 0B 48 8B 44 24 ?? 48 89 04 24 48 8B 44 24 ?? 48 89 44 24 ?? 48 8D 05 ?? ?? 
            ?? ?? 48 89 44 24 ?? E8 ?? ?? ?? ?? EB ?? E8 ?? ?? ?? ?? E9
        }

        $attach_to_server_64 = {
            65 48 8B 0C 25 ?? ?? ?? ?? 48 8B 89 ?? ?? ?? ?? 48 3B 61 ?? 0F 86 ?? ?? ?? ?? 48 83 
            EC ?? 48 89 6C 24 ?? 48 8D 6C 24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? 48 C7 84 24 ?? ?? ?? 
            ?? ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 04 24 E8 ?? ?? ?? ?? 48 8B 7C 24 ?? 48 89 
            7C 24 ?? 84 07 0F 57 C0 48 83 C7 ?? 48 89 6C 24 ?? 48 8D 6C 24 ?? E8 ?? ?? ?? ?? 48 
            8B 6D ?? 48 8B 44 24 ?? 48 89 04 24 48 8B 4C 24 ?? 48 89 4C 24 ?? 48 8B 4C 24 ?? 48 
            89 4C 24 ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 89 04 24 48 8D 0D ?? ?? ?? ?? 48 89 4C 
            24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 89 04 24 48 8D 0D 
            ?? ?? ?? ?? 48 89 4C 24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 
            48 89 04 24 48 8B 4C 24 ?? 48 89 4C 24 ?? 48 8B 4C 24 ?? 48 89 4C 24 ?? E8 ?? ?? ?? 
            ?? 48 8B 44 24 ?? 48 8B 48 ?? 48 8B 10 48 8B 58 ?? 48 8B 40 ?? 48 39 CB 0F 87 ?? ?? 
            ?? ?? 48 29 D9 48 29 D8 48 85 C0 0F 84 ?? ?? ?? ?? 48 C7 04 24 ?? ?? ?? ?? 48 01 DA 
            48 89 54 24 ?? 48 89 4C 24 ?? 48 89 44 24 ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 4C 
            24 ?? 48 89 0C 24 48 89 44 24 ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 89 44 24 ?? 48 8B 
            48 ?? 48 8B 50 ?? 84 01 48 89 54 24 ?? C7 04 24 ?? ?? ?? ?? 48 83 C1 ?? 48 89 4C 24 
            ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 04 24 48 8B 44 
            24 ?? 48 8B 48 ?? 48 8B 40 ?? 48 89 4C 24 ?? 48 89 44 24 ?? E8 ?? ?? ?? ?? 48 8B 44 
            24 ?? 48 8B 4C 24 ?? 48 89 04 24 48 89 4C 24 ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 
            4C 24 ?? 48 8B 54 24 ?? 48 C7 04 24 ?? ?? ?? ?? 48 89 44 24 ?? 48 89 4C 24 ?? 48 89 
            54 24 ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 4C 24 ?? 48 89 44 24 ?? 48 89 8C 24 ?? 
            ?? ?? ?? 90 E8 ?? ?? ?? ?? 48 8B 6C 24 ?? 48 83 C4 ?? C3 90 E8 ?? ?? ?? ?? 48 8B 6C 
            24 ?? 48 83 C4 ?? C3 31 DB E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 0B E8 ?? ?? ?? ?? E9
        }

        $encrypt_file_64 = {
            65 48 8B 0C 25 ?? ?? ?? ?? 48 8B 89 ?? ?? ?? ?? 48 3B 61 ?? 0F 86 ?? ?? ?? ?? 48 83 
            EC ?? 48 89 6C 24 ?? 48 8D 6C 24 ?? 48 8B 44 24 ?? 48 89 04 24 48 8B 44 24 ?? 48 89 
            44 24 ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 4C 24 ?? 48 8B 54 24 ?? 48 89 04 24 48 
            89 4C 24 ?? 48 89 54 24 ?? 48 8B 44 24 ?? 48 89 44 24 ?? 48 8B 84 24 ?? ?? ?? ?? 48 
            89 44 24 ?? 48 8B 84 24 ?? ?? ?? ?? 48 89 44 24 ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 
            8B 4C 24 ?? 48 8B 54 24 ?? 48 8B 5C 24 ?? 48 89 1C 24 48 8B 5C 24 ?? 48 89 5C 24 ?? 
            48 89 44 24 ?? 48 89 4C 24 ?? 48 89 54 24 ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            48 8B 6C 24 ?? 48 83 C4 ?? C3 E8 ?? ?? ?? ?? E9
        }

    condition:
        uint16(0) == 0x5A4D and (($get_files_for_encryption_32 and $encrypt_file_32 and $attach_to_server_32) or
        ($get_files_for_encryption_64 and $encrypt_file_64 and $attach_to_server_64))
}